<? if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();
/** @var array $arParams */
/** @var array $arResult */
/** @global CMain $APPLICATION */
/** @global CUser $USER */
/** @global CDatabase $DB */
/** @var CBitrixComponentTemplate $this */
/** @var string $templateName */
/** @var string $templateFile */
/** @var string $templateFolder */
/** @var string $componentPath */
/** @var CBitrixComponent $component */
$this->setFrameMode(true);
if ($arResult["ITEMS"]):?>

    <section class="reviews-slider">
        <?php if($arParams['BLOCK_TITLE']):?>
            <h2 class="title-block underline"><?php echo $arParams['BLOCK_TITLE']?></h2>
        <?php endif?>
        <div class="reviews-slider__wrapper slider">
            <div class="reviews-slider__list swiper-wrapper">
            <? foreach ($arResult["ITEMS"] as $arItem):?>
                <?
                $this->AddEditAction($arItem['ID'], $arItem['EDIT_LINK'], CIBlock::GetArrayByID($arItem["IBLOCK_ID"], "ELEMENT_EDIT"));
                $this->AddDeleteAction($arItem['ID'], $arItem['DELETE_LINK'], CIBlock::GetArrayByID($arItem["IBLOCK_ID"], "ELEMENT_DELETE"), array("CONFIRM" => GetMessage('CT_BNL_ELEMENT_DELETE_CONFIRM')));
                $file = CFile::ResizeImageGet($arItem["PREVIEW_PICTURE"], array('width'=>160, 'height'=>230), BX_RESIZE_IMAGE_PROPORTIONAL, true);
                ?>
                <article class="reviews-slider__item slider__item swiper-slide" id="<?= $this->GetEditAreaId($arItem['ID']); ?>">
                     <?php if($arItem["PREVIEW_PICTURE"]):?>
                        <a href="<?= $arItem["PREVIEW_PICTURE"]["SRC"] ?>" class="fancybox reviews-slider__image">
                                <img
                                    class="preview_picture"
                                    border="0"
                                    src="<?= $file['src'] ?>"
                                    width="<?= $arItem["PREVIEW_PICTURE"]["WIDTH"] ?>"
                                    height="<?= $arItem["PREVIEW_PICTURE"]["HEIGHT"] ?>"
                                    alt="<?= $arItem["PREVIEW_PICTURE"]["ALT"] ?>"
                                    title="<?= $arItem["PREVIEW_PICTURE"]["TITLE"] ?>"
                            /></a>
                    <?php endif?>
                    <blockquote class="reviews-slider__info">
                        <cite class="reviews-slider__name"><?php echo $arItem['NAME'] ?></cite>
                        <?php if($arItem['PROPERTIES']['POST']['VALUE']):?>
                            <p class="reviews-slider__position"><?php echo $arItem['PROPERTIES']['POST']['VALUE']?></p>
                        <?php endif?>
                        <div class="reviews-slider__text js-text-review-more">
                            <?php echo $arItem['PREVIEW_TEXT'] ?>
                            <div class="reviews-slider__more">
                                <a href="#" class="reviews-slider__more-link">Читать далее</a>
                            </div>
                        </div>
                    </blockquote>
                </article>
            <? endforeach; ?>
        </div>
            <div class="slider__button slider__button--prev"><i class="slider__button-icon"></i></div>
            <div class="slider__button slider__button--next"><i  class="slider__button-icon"></i></div>
        </div>
    </section>
    <script>
        ;(()=>{
        const reviews = $('.reviews-slider__wrapper');
        const texts = reviews.find('.js-text-review-more');
        new Swiper('.reviews-slider__wrapper', {
            lazy: true,
            slidesPerView: 2,
            spaceBetween: 20,
            navigation: {
                nextEl: ".reviews-slider__wrapper .slider__button--next",
                prevEl: ".reviews-slider__wrapper .slider__button--prev",
            },
            breakpoints: {
                320: {
                    slidesPerView: 1,
                },
                480: {
                    slidesPerView: 2,
                },
            }
        });
        texts.each((idx, el) => {
            const button = el.querySelector('.reviews-slider__more');
            const link = button.querySelector('.reviews-slider__more-link');
            const height = el.scrollHeight;

            if(height > 276) {
                button.classList.add('is-active');
            }

            link.addEventListener('click', (evt) => {
                evt.preventDefault();
                el.classList.toggle('is-open');

                if(el.classList.contains('is-open')) {
                    link.textContent = 'Свернуть';
                }else {
                    link.textContent = 'Читать далее';
                }
            })
        });
        })();
    </script>
<?php endif;