<? if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();
/** @var array $arParams */
/** @var array $arResult */
/** @global CMain $APPLICATION */
/** @global CUser $USER */
/** @global CDatabase $DB */
/** @var CBitrixComponentTemplate $this */
/** @var string $templateName */
/** @var string $templateFile */
/** @var string $templateFolder */
/** @var string $componentPath */
/** @var CBitrixComponent $component */
$this->setFrameMode(true);
if ($arResult["ITEMS"]):?>

    <section class="certificates">
        <?php if($arParams['BLOCK_TITLE']):?>
            <h2 class="title-block underline"><?php echo $arParams['BLOCK_TITLE']?></h2>
        <?php endif?>
        <div class="certificates__slider slider">
            <div class="certificates__list swiper-wrapper">
            <? foreach ($arResult["ITEMS"] as $arItem):?>
                <?
                $this->AddEditAction($arItem['ID'], $arItem['EDIT_LINK'], CIBlock::GetArrayByID($arItem["IBLOCK_ID"], "ELEMENT_EDIT"));
                $this->AddDeleteAction($arItem['ID'], $arItem['DELETE_LINK'], CIBlock::GetArrayByID($arItem["IBLOCK_ID"], "ELEMENT_DELETE"), array("CONFIRM" => GetMessage('CT_BNL_ELEMENT_DELETE_CONFIRM')));
                $file = CFile::ResizeImageGet($arItem["PREVIEW_PICTURE"], array('width'=>220, 'height'=>300), BX_RESIZE_IMAGE_PROPORTIONAL, true);
                ?>
                <p class="certificates__item slider__item swiper-slide" id="<?= $this->GetEditAreaId($arItem['ID']); ?>">
                    <a href="<?= $arItem["PREVIEW_PICTURE"]["SRC"] ?>" class="fancybox" data-fancybox-group="fancybox-certificates"><img
                                class="preview_picture"
                                src="<?= $file['src'] ?>"
                                width="<?= $arItem["PREVIEW_PICTURE"]["WIDTH"] ?>"
                                height="<?= $arItem["PREVIEW_PICTURE"]["HEIGHT"] ?>"
                                alt="<?= $arItem["PREVIEW_PICTURE"]["ALT"] ?>"
                                title="<?= $arItem["PREVIEW_PICTURE"]["TITLE"] ?>"
                        /></a>
                </p>
            <? endforeach; ?>
        </div>
            <div class="slider__button slider__button--prev"><i class="slider__button-icon"></i></div>
            <div class="slider__button slider__button--next"><i  class="slider__button-icon"></i></div>
        </div>
    </section>
    <script>
        new Swiper('.certificates__slider', {
            lazy: true,
            slidesPerView: 4,
            spaceBetween: 20,
            navigation: {
                nextEl: ".certificates__slider .slider__button--next",
                prevEl: ".certificates__slider .slider__button--prev",
            },
            breakpoints: {
                320: {
                    slidesPerView: 1,
                },
                480: {
                    slidesPerView: 2,
                },
                768: {
                    slidesPerView: 4,
                }
            }
        });
    </script>
<?php endif;