/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./components/accordion/js/index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./components/accordion/js/accordions.js":
/*!***********************************************!*\
  !*** ./components/accordion/js/accordions.js ***!
  \***********************************************/
/*! exports provided: Accordions */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Accordions", function() { return Accordions; });
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var Accordions = /*#__PURE__*/function () {
  function Accordions() {
    _classCallCheck(this, Accordions);
    this._openHeight = 0;
    this._windowWidth = window.innerWidth;
    this._documentClickHandler = this._documentClickHandler.bind(this);
    this._windowResizeHandler = this._windowResizeHandler.bind(this);
    this._init();
  }
  _createClass(Accordions, [{
    key: "_init",
    value: function _init() {
      this.fullUpdate();
      document.addEventListener('click', this._documentClickHandler);
      window.addEventListener('resize', this._windowResizeHandler);
    }
  }, {
    key: "_documentClickHandler",
    value: function _documentClickHandler(evt) {
      var target = evt.target;
      if (!target.closest('[data-accordion="button"]')) {
        return;
      }
      evt.preventDefault();
      var parent = target.closest('[data-accordion="parent"]');
      if (parent.dataset.destroy && !window.matchMedia(parent.dataset.destroy).matches) {
        return;
      }
      var element = target.closest('[data-accordion="element"]');
      if (element.classList.contains('is-active')) {
        this.closeAccordion(element);
        return;
      }
      this.openAccordion(element);
    }
  }, {
    key: "_windowResizeHandler",
    value: function _windowResizeHandler() {
      if (this._windowWidth === window.innerWidth) {
        return;
      }
      this._windowWidth = window.innerWidth;
      this.updateAccordionsHeight();
    }
  }, {
    key: "closeAllAccordion",
    value: function closeAllAccordion(parent) {
      var _this = this;
      var elements = parent.querySelectorAll('[data-accordion="element"]');
      elements.forEach(function (element) {
        var currentParent = element.closest('[data-accordion="parent"]');
        if (currentParent === parent) {
          _this.closeAccordion(element);
        }
      });
    }
  }, {
    key: "updateAccordionsHeight",
    value: function updateAccordionsHeight() {
      var element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      if (element) {
        var content = element.querySelector('[data-accordion="content"]');
        content.style.transition = 'none';
        content.style.maxHeight = "".concat(content.scrollHeight, "px");
        setTimeout(function () {
          content.style.transition = null;
        });
        return;
      }
      var closeElements = document.querySelectorAll('[data-accordion="element"]:not(.is-active)');
      closeElements.forEach(function (closeElement) {
        var parent = closeElement.closest('[data-accordion="parent"]');
        var content = closeElement.querySelector('[data-accordion="content"]');
        if (parent.dataset.destroy && !window.matchMedia(parent.dataset.destroy).matches) {
          content.style.maxHeight = '100%';
          return;
        }
        content.style.maxHeight = null;
      });
      var openElements = document.querySelectorAll('[data-accordion="element"].is-active');
      openElements.forEach(function (openElement) {
        var content = openElement.querySelector('[data-accordion="content"]');
        var parent = openElement.closest('[data-accordion="parent"]');
        if (parent.dataset.destroy && !window.matchMedia(parent.dataset.destroy).matches) {
          content.style.maxHeight = '100%';
          return;
        }
        content.style.transition = 'none';
        content.style.maxHeight = "".concat(content.scrollHeight, "px");
        setTimeout(function () {
          content.style.transition = null;
        });
      });
    }
  }, {
    key: "fullUpdate",
    value: function fullUpdate() {
      var _this2 = this;
      var parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var transition = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var openElements;
      if (parent) {
        openElements = parent.querySelectorAll('[data-accordion="element"].is-active');
      } else {
        openElements = document.querySelectorAll('[data-accordion="element"].is-active');
      }
      openElements.forEach(function (openElement) {
        var innerParent = openElement.querySelector('[data-accordion="parent"]');
        if (innerParent) {
          return;
        }
        _this2.openAccordion(openElement, transition);
      });
      this.updateAccordionsHeight();
    }
  }, {
    key: "openAccordion",
    value: function openAccordion(element) {
      var transition = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var parentElement = element.closest('[data-accordion="parent"]');
      var contentElement = element.querySelector('[data-accordion="content"]');
      this._openHeight += contentElement.scrollHeight;
      if (parentElement.hasAttribute('data-single')) {
        this.closeAllAccordion(parentElement);
      }
      element.classList.add('is-active');
      if (transition) {
        contentElement.style.maxHeight = "".concat(this._openHeight, "px");
      } else {
        contentElement.style.transition = 'none';
        contentElement.style.maxHeight = "".concat(this._openHeight, "px");
        setTimeout(function () {
          contentElement.style.transition = null;
        });
      }
      if (parentElement.closest('[data-accordion="element"]')) {
        this.openAccordion(parentElement.closest('[data-accordion="element"]'), transition);
        return;
      }
      this._openHeight = 0;
    }
  }, {
    key: "closeAccordion",
    value: function closeAccordion(element) {
      var transition = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var contentElement = element.querySelector('[data-accordion="content"]');
      if (!contentElement) {
        return;
      }
      element.classList.remove('is-active');
      if (transition) {
        contentElement.style.maxHeight = '0';
      } else {
        contentElement.style.transition = 'none';
        contentElement.style.maxHeight = '0';
        setTimeout(function () {
          contentElement.style.transition = null;
        });
      }
    }
  }]);
  return Accordions;
}();

/***/ }),

/***/ "./components/accordion/js/index.js":
/*!******************************************!*\
  !*** ./components/accordion/js/index.js ***!
  \******************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _init_accordion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./init-accordion */ "./components/accordion/js/init-accordion.js");

window.addEventListener('DOMContentLoaded', function () {
  window.addEventListener('load', function () {
    Object(_init_accordion__WEBPACK_IMPORTED_MODULE_0__["initAccordions"])();
  });
});

/***/ }),

/***/ "./components/accordion/js/init-accordion.js":
/*!***************************************************!*\
  !*** ./components/accordion/js/init-accordion.js ***!
  \***************************************************/
/*! exports provided: initAccordions, accordions */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "initAccordions", function() { return initAccordions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "accordions", function() { return accordions; });
/* harmony import */ var _accordions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./accordions */ "./components/accordion/js/accordions.js");

var accordions;
var initAccordions = function initAccordions() {
  accordions = new _accordions__WEBPACK_IMPORTED_MODULE_0__["Accordions"]();
  // Используйте в разработке экспортируемую переменную accordions, window сделан для бэкэнда
  window.accordions = accordions;
};


/***/ })

/******/ });
//# sourceMappingURL=accordion.min.js.map