<?php if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

use Bitrix\Main\Loader;
use Bitrix\Highloadblock\HighloadBlockTable as HLBT;

class Helper
{
    public static function GetEntityDataClass($HlBlockId)
    {
        if (empty($HlBlockId) || $HlBlockId < 1) {
            return false;
        }
        Loader::includeModule('highloadblock');

        $hlblock = HLBT::getById($HlBlockId)->fetch();
        $entity = HLBT::compileEntity($hlblock);
        $entity_data_class = $entity->getDataClass();
        return $entity_data_class;
    }

    public static function GetFields($id, array $arFields = array())
    {

        if (!$id) return array();

        $arResult = array();
        $entity_data_class = Helper::GetEntityDataClass($id);


        $rsData = $entity_data_class::getList(array(
            'select' => (empty($arFields)) ? array('*') : $arFields,
            'order' => array('UF_SORT' => 'ASC')
        ));

        while ($el = $rsData->fetch()) {
            $arResult[] = $el;
        }

        return $arResult;
    }
}
